#ifndef ASM_H
#define ASM_H
#ifndef UNIV_H
#include "univ.h"
#endif

class Instr : public PadRcv {
PUBLIC(Instr,U_INSTR)
	long	addr;
	long	next;
	Asm	*_asm;
	int	fmt;
	Cslfd	m;
	char	bpt;
	char	reg;
	char	opcode;

	Index	carte();
	void	reformat(int);
	Instr	*sib;
	char	*literal(long);
	char	*symbolic(char* ="");
	Var	*local(UDisc, long);
	Var	*field(Var*, long);
	char	*regarg(char*, long);
	void	succ(int);
	void	memory();
	void	dobpt(int);
	void	showsrc();
	void	openframe();
	void	display();

virtual	char	*arg(int);
virtual	char	*mnemonic();
virtual	int	argtype(int);
virtual	int	nargs();
	
		Instr(Asm*,long);
};

class Asm : public PadRcv {
	friend Instr;
	friend M68kInstr;
	friend SparcInstr;
	friend Mac32Instr;
	friend Dsp32Instr;
	friend MipsInstr;
	friend I386Instr;
protected:
	int	fmt;
	Core	*core;
	Pad	*pad;
	Instr	*instrset;
	void	instrstep(long);
	void	stepover();
	void	displaypc();
	void	go();
	void	pop();
	void	stop();

virtual char	*literaldelimiter();
virtual Instr	*newInstr(long l);
PUBLIC(Asm,U_ASM)
		Asm(Core*);
	char	*kbd(char *);
	char	*help(long);
	void	userclose();
	void	open(long=0);
	void	banner();
};
#endif
